/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.contraptions.base;

import com.jozufozu.flywheel.backend.Backend;
import com.simibubi.create.AllBlocks;
import com.simibubi.create.content.contraptions.KineticDebugger;
import com.simibubi.create.content.contraptions.base.IRotate;
import com.simibubi.create.content.contraptions.base.KineticTileEntity;
import com.simibubi.create.content.contraptions.relays.elementary.ICogWheel;
import com.simibubi.create.foundation.render.CachedBufferer;
import com.simibubi.create.foundation.render.SuperByteBuffer;
import com.simibubi.create.foundation.render.SuperByteBufferCache;
import com.simibubi.create.foundation.tileEntity.renderer.SafeTileEntityRenderer;
import com.simibubi.create.foundation.utility.AnimationTickHolder;
import com.simibubi.create.foundation.utility.Color;
import net.minecraft.class_1921;
import net.minecraft.class_1936;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2680;
import net.minecraft.class_2741;
import net.minecraft.class_2769;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_4597;
import net.minecraft.class_4696;
import net.minecraft.class_5614;

public class KineticTileEntityRenderer
extends SafeTileEntityRenderer<KineticTileEntity> {
    public static final SuperByteBufferCache.Compartment<class_2680> KINETIC_TILE = new SuperByteBufferCache.Compartment();
    public static boolean rainbowMode = false;

    public KineticTileEntityRenderer(class_5614.class_5615 context) {
    }

    @Override
    protected void renderSafe(KineticTileEntity te, float partialTicks, class_4587 ms, class_4597 buffer, int light, int overlay) {
        if (Backend.canUseInstancing((class_1937)te.method_10997())) {
            return;
        }
        class_2680 state = this.getRenderedBlockState(te);
        class_1921 type = this.getRenderType(te, state);
        if (type != null) {
            KineticTileEntityRenderer.renderRotatingBuffer(te, this.getRotatedModel(te, state), ms, buffer.getBuffer(type), light);
        }
    }

    protected class_2680 getRenderedBlockState(KineticTileEntity te) {
        return te.method_11010();
    }

    protected class_1921 getRenderType(KineticTileEntity te, class_2680 state) {
        return class_4696.method_23679((class_2680)state);
    }

    protected SuperByteBuffer getRotatedModel(KineticTileEntity te, class_2680 state) {
        return CachedBufferer.block(KINETIC_TILE, state);
    }

    public static void renderRotatingKineticBlock(KineticTileEntity te, class_2680 renderedState, class_4587 ms, class_4588 buffer, int light) {
        SuperByteBuffer superByteBuffer = CachedBufferer.block(KINETIC_TILE, renderedState);
        KineticTileEntityRenderer.renderRotatingBuffer(te, superByteBuffer, ms, buffer, light);
    }

    public static void renderRotatingBuffer(KineticTileEntity te, SuperByteBuffer superBuffer, class_4587 ms, class_4588 buffer, int light) {
        KineticTileEntityRenderer.standardKineticRotationTransform(superBuffer, te, light).renderInto(ms, buffer);
    }

    public static float getAngleForTe(KineticTileEntity te, class_2338 pos, class_2350.class_2351 axis) {
        float time = AnimationTickHolder.getRenderTime((class_1936)te.method_10997());
        float offset = KineticTileEntityRenderer.getRotationOffsetForPosition(te, pos, axis);
        float angle = (time * te.getSpeed() * 3.0f / 10.0f + offset) % 360.0f / 180.0f * (float)Math.PI;
        return angle;
    }

    public static SuperByteBuffer standardKineticRotationTransform(SuperByteBuffer buffer, KineticTileEntity te, int light) {
        class_2338 pos = te.method_11016();
        class_2350.class_2351 axis = ((IRotate)te.method_11010().method_26204()).getRotationAxis(te.method_11010());
        return KineticTileEntityRenderer.kineticRotationTransform(buffer, te, axis, KineticTileEntityRenderer.getAngleForTe(te, pos, axis), light);
    }

    public static SuperByteBuffer kineticRotationTransform(SuperByteBuffer buffer, KineticTileEntity te, class_2350.class_2351 axis, float angle, int light) {
        buffer.light(light);
        buffer.rotateCentered(class_2350.method_10156((class_2350.class_2352)class_2350.class_2352.field_11056, (class_2350.class_2351)axis), angle);
        if (KineticDebugger.isActive()) {
            rainbowMode = true;
            buffer.color(te.hasNetwork() ? Color.generateFromLong(te.network) : Color.WHITE);
        } else {
            float overStressedEffect = te.effects.overStressedEffect;
            if (overStressedEffect != 0.0f) {
                if (overStressedEffect > 0.0f) {
                    buffer.color(Color.WHITE.mixWith(Color.RED, overStressedEffect));
                } else {
                    buffer.color(Color.WHITE.mixWith(Color.SPRING_GREEN, -overStressedEffect));
                }
            } else {
                buffer.color(Color.WHITE);
            }
        }
        return buffer;
    }

    public static float getRotationOffsetForPosition(KineticTileEntity te, class_2338 pos, class_2350.class_2351 axis) {
        float offset = ICogWheel.isLargeCog(te.method_11010()) ? 11.25f : 0.0f;
        double d = ((axis == class_2350.class_2351.field_11048 ? 0 : pos.method_10263()) + (axis == class_2350.class_2351.field_11052 ? 0 : pos.method_10264()) + (axis == class_2350.class_2351.field_11051 ? 0 : pos.method_10260())) % 2;
        if (d == 0.0) {
            offset = 22.5f;
        }
        return offset + (float)te.getRotationAngleOffset(axis);
    }

    public static class_2680 shaft(class_2350.class_2351 axis) {
        return (class_2680)AllBlocks.SHAFT.getDefaultState().method_11657((class_2769)class_2741.field_12496, (Comparable)axis);
    }

    public static class_2350.class_2351 getRotationAxisOf(KineticTileEntity te) {
        return ((IRotate)te.method_11010().method_26204()).getRotationAxis(te.method_11010());
    }
}

